/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.property;

import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.Vec3;
import xfacthd.framedblocks.api.util.Utils;

public enum HorizontalRotation implements StringRepresentable
{
    UP(dir -> Direction.UP),
    DOWN(dir -> Direction.DOWN),
    RIGHT(Direction::m_122427_),
    LEFT(Direction::m_122428_);

    private final String name = this.toString().toLowerCase(Locale.ROOT);
    private final Function<Direction, Direction> facingMod;

    private HorizontalRotation(Function<Direction, Direction> facingMod) {
        this.facingMod = facingMod;
    }

    public Direction withFacing(Direction dir) {
        return this.facingMod.apply(dir);
    }

    public HorizontalRotation getOpposite() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case UP -> DOWN;
            case DOWN -> UP;
            case RIGHT -> LEFT;
            case LEFT -> RIGHT;
        };
    }

    public HorizontalRotation rotate(Rotation rot) {
        return switch (rot) {
            default -> throw new IncompatibleClassChangeError();
            case Rotation.NONE -> this;
            case Rotation.CLOCKWISE_180 -> this.getOpposite();
            case Rotation.CLOCKWISE_90 -> {
                switch (this) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case UP: {
                        yield RIGHT;
                    }
                    case DOWN: {
                        yield LEFT;
                    }
                    case RIGHT: {
                        yield DOWN;
                    }
                    case LEFT: 
                }
                yield UP;
            }
            case Rotation.COUNTERCLOCKWISE_90 -> {
                switch (this) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case UP: {
                        yield LEFT;
                    }
                    case DOWN: {
                        yield RIGHT;
                    }
                    case RIGHT: {
                        yield UP;
                    }
                    case LEFT: 
                }
                yield DOWN;
            }
        };
    }

    public boolean isVertical() {
        return this == UP || this == DOWN;
    }

    public String m_7912_() {
        return this.name;
    }

    public static HorizontalRotation fromDirection(Direction facing, Direction dir) {
        Preconditions.checkArgument((!Utils.isY(facing) ? 1 : 0) != 0, (Object)"View direction must not be on the Y axis");
        Preconditions.checkArgument((facing.m_122434_() != dir.m_122434_() ? 1 : 0) != 0, (Object)"Directions must be perpendicular");
        if (dir == Direction.UP) {
            return UP;
        }
        if (dir == Direction.DOWN) {
            return DOWN;
        }
        if (dir == facing.m_122427_()) {
            return RIGHT;
        }
        if (dir == facing.m_122428_()) {
            return LEFT;
        }
        throw new IllegalStateException(String.format("How did we get here?! %s|%s", facing, dir));
    }

    public static HorizontalRotation fromWallCross(Vec3 hitVec, Direction hitFace) {
        hitVec = Utils.fraction(hitVec);
        double xz = (Utils.isX(hitFace) ? hitVec.m_7094_() : hitVec.m_7096_()) - 0.5;
        double y = hitVec.m_7098_() - 0.5;
        if (Math.max(Math.abs(xz), Math.abs(y)) == Math.abs(xz)) {
            if (Utils.isX(hitFace)) {
                return xz < 0.0 == Utils.isPositive(hitFace) ? LEFT : RIGHT;
            }
            return xz < 0.0 == Utils.isPositive(hitFace) ? RIGHT : LEFT;
        }
        return y < 0.0 ? UP : DOWN;
    }
}

